/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.item.combat.abilities.armor.GravititeArmor;
import com.aetherteam.aether.item.combat.abilities.armor.NeptuneArmor;
import com.aetherteam.aether.item.combat.abilities.armor.PhoenixArmor;
import com.aetherteam.aether.item.combat.abilities.armor.ValkyrieArmor;
import com.aetherteam.aetherfabric.events.EntityTickEvents;
import com.aetherteam.aetherfabric.events.FallHelper;
import com.aetherteam.aetherfabric.events.LivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class ArmorAbilityListener {
    public static void listen() {
        EntityTickEvents.AFTER.register(ArmorAbilityListener::onEntityUpdate);
        LivingEntityEvents.ON_JUMP.register(ArmorAbilityListener::onEntityJump);
        LivingEntityEvents.ON_FALL.register(ArmorAbilityListener::onEntityFall);
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> ArmorAbilityListener.onEntityAttack(entity, source));
    }

    public static void onEntityUpdate(class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            ValkyrieArmor.handleFlight(livingEntity);
            NeptuneArmor.boostWaterSwimming(livingEntity);
            PhoenixArmor.boostLavaSwimming(livingEntity);
            PhoenixArmor.damageArmor(livingEntity);
        }
    }

    public static void onEntityJump(class_1309 livingEntity) {
        GravititeArmor.boostedJump(livingEntity);
    }

    public static void onEntityFall(class_1309 entity, FallHelper event) {
        if (!event.isCanceled()) {
            event.setCanceled(AbilityHooks.ArmorHooks.fallCancellation(entity));
        }
    }

    public static boolean onEntityAttack(class_1309 livingEntity, class_1282 damageSource) {
        return !PhoenixArmor.extinguishUser(livingEntity, damageSource);
    }
}

